(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     61066,       2253]*)
(*NotebookOutlinePosition[     62151,       2288]*)
(*  CellTagsIndexPosition[     62107,       2284]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["One Time Pad Cryptosystem", "Title",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Colin P. Williams", "Subsubtitle",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Copyright Notice", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with \"Explorations in \
Quantum Computing\" by Colin P. Williams and Scott H. Clearwater, TELOS, \
Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to \
copy and distribute this Notebook freely for any non-commercial activity \
provided you include this copyright notice at the beginning of all such \
copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on \"Explorations in Quantum Computing\" check out the TELOS \
web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To \
order call 1-800-777-4643.

All other rights reserved.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["How to use this Notebook", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This Notebook contains output from a simulation of a one time pad \
cryptosystem. See \"Explorations in Quantum Computing\", Chapter 6. One time \
pads are extremely secure cryptosystems provided the identity of the key pads \
remains secret i.e. known only to the sender and the intended recipient of \
the messages.

Quantum key distribution could be used to distribute new keys for a one time \
pad in an \"as needed\" but highly secure fashion. See \"Explorations in \
Quantum Computing\", Chapter 8 for more information on quantum key \
distribution.

Please note that all active components of our implementation of the OTP \
cryptosystem have been deleted from this CD-ROM to ensure compliance with \
U.S. Federal Law regarding Department of Commerce prohibitions on the export \
of cryptographic software.  The examples below are sufficient to illustrate \
the general principles behind One Time Pads but they will not permit you to \
generate any new examples for yourself. We may be able to export the active \
code components of the One Time Pad simulator in the future subject to U.S. \
government approval.\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Encryption/Decryption Using \"One Time Pads\"", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
One time pads are extremely secure but they require the person who \
sends a coded message to meet with the person who will receive the coded \
message beforehand and covertly agree upon a common pad of keys. One the key \
pad has been created and a copy given to the sender and receiver of a message \
secure messages can be exchanged as follows: \
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
A message is a string of symbols from some finite alphabet. Each \
distinct symbol is associated with a unique integer in the range 0 to l-1, \
where  l is the number of symbols in the \"alphabet\". The i-th encrypted \
integer is the sum (modulo l) of the i-th message integer plus the i-th key \
integer (on the agreed upon page in the pre-computed pad of keys). Thus, \
\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Message (converted to integers) = {m1, m2, m3, ..., mN}
Keys                            = {k1, k2, k3, ..., kN}
Encrypted Message               = {e1, e2, e3, ..., eN} 
\
\>", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell["where ei = mi + ki (mod l).", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example of a One Time Pad", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Here is an example of a message encrypted and decrypted using a One \
Time Pad. 

Suppose Alice wishes to send a message to Bob.  To do so, Alice and Bob must \
already have met and agreed upon certain rules of communication. First they \
have agreed to use the same alphabet, such as $Alphabet below:
\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
$Alphabet =
\t{\"a\", \"b\", \"c\", \"d\", \"e\", \"f\", \"g\", \"h\", \"i\", \"j\", \
\"k\", 
\t \"l\", \"m\", \"n\", \"o\", \"p\", \"q\", \"r\", \"s\", \"t\", \"u\", \
\"v\", 
\t \"w\", \"x\", \"y\", \"z\", \"A\", \"B\", \"C\", \"D\", \"E\", \"F\", \
\"G\", 
\t \"H\", \"I\", \"J\", \"K\", \"L\", \"M\", \"N\", \"O\", \"P\", \"Q\", \
\"R\", 
\t \"S\", \"T\", \"U\", \"V\", \"W\", \"X\", \"Y\", \"Z\", \"1\", \"2\", \
\"3\", 
\t \"4\", \"5\", \"6\", \"7\", \"8\", \"9\", \"0\", \"!\", \"?\", \".\", \
\",\", 
\t \";\", \":\", \"(\", \")\", \"{\", \"}\", \"[\", \"]\", \" \", \"'\"};
\
\>", "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Moreover, Alice and Bob must already have agreed to associate each \
symbol in the alphabet with a unique integer between 0 and l-1 where l is the \
number of distinct symbols in the alphabet. The association is arbitrary so \
long as Alice and Bob use it consistently and all characters have an equal \
number of digits. Here is a simple encoding ...\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["MessageToIntegers[\"abcdef   ABCDEF\", $Alphabet]", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{0, 1, 2, 3, 4, 5, 74, 74, 74, 26, 27, 28, 29, 30, 31}\
\>", 
"\<\
{0, 1, 2, 3, 4, 5, 74, 74, 74, 26, 27, 28, 29, 30, 31}\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
Notice a blank space is assigned the integer 74. Thus a proper \
message would look something like this ... \
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["MessageToIntegers[\"Telephone 555 1212!\", $Alphabet]", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, 53, 62}\
\
\>", "\<\
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, \
53, 62}\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
Also, and most importantly, Alice and Bob must have already \
generated a huge set of random integers, or \"keys\", uniformly in the range \
0 to l-1 and recorded them in 2 identical booklets or \"pads\", one kept by \
Alice and the other by Bob. When Alice or Bob want to send a message, they \
begin by informing the other party (publicly) which page they are using as \
the source of the keys. Provided they have guarded the key pads from other \
people, this communicates no useful information to an adversary. Moreover, \
once the message has been encrypted, transmitted and decoded successfully \
Alice and Bob rip out the page in the key pad that was used as the source of \
keys, never to use it again. The use of pads of keys that are used only once \
explains the reason for the name \"one time pad\".\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["?MakeKeyPad", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell["\<\
MakeKeyPad[alphabet, n, k] creates a pad of keys containing n pages \
and k keys per
   page. Each key is a random integer picked uniformly and independently in \
the
   range 0 to Length[alphabet]-1.\
\>", "Print",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["$Pad = MakeKeyPad[$Alphabet, 1000, 100];", "Input",
  Editable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
In this case the pad, $Pad, contains 1000 pages of 100 keys per \
page. Here are the first 10 pages of the pad, $Pad, written one page per \
line:\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
SetOptions[$Output, PageWidth->Infinity];
MatrixForm[Take[$Pad, {1, 10}]]\
\>", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
MatrixForm[{{54, 0, 72, 25, 41, 52, 36, 34, 56, 42, 48, 27, 70, 33, 16, \
0, 22, 22, 56, 2, 21, 39, 24, 33, 11, 58, 38, 37, 30, 2, 54, 43, 19, 6, 58, \
20, 8, 36, 70, 26, 26, 30, 34, 25, 60, 6, 72, 12, 14, 71, 72, 24, 46, 69, 67, \
57, 35, 62, 75, 30, 18, 65, 58, 2, 38, 38, 63, 50, 32, 60, 9, 67, 46, 75, 4, \
36, 57, 24, 22, 0, 55, 50, 4, 20, 26, 44, 28, 61, 69, 48, 44, 27, 56, 12, 22, \
9, 58, 24, 36, 17}, {54, 31, 35, 29, 10, 64, 73, 20, 66, 51, 30, 64, 64, 17, \
57, 11, 44, 58, 51, 73, 62, 28, 30, 9, 14, 3, 60, 74, 62, 50, 54, 71, 56, 32, \
54, 19, 58, 15, 40, 9, 60, 62, 11, 64, 51, 60, 30, 42, 14, 46, 56, 58, 10, \
70, 27, 70, 0, 36, 26, 22, 43, 53, 72, 6, 26, 7, 40, 18, 74, 69, 19, 17, 15, \
8, 37, 11, 71, 36, 70, 68, 52, 44, 62, 17, 69, 60, 62, 31, 14, 43, 64, 42, \
56, 7, 5, 25, 43, 60, 26, 45}, {48, 60, 25, 17, 47, 1, 61, 39, 21, 30, 63, \
68, 39, 10, 39, 0, 12, 35, 49, 60, 51, 71, 32, 4, 58, 49, 27, 16, 16, 69, 49, \
4, 48, 74, 65, 55, 45, 52, 75, 48, 33, 9, 11, 9, 69, 37, 61, 70, 53, 39, 47, \
48, 53, 43, 44, 40, 17, 52, 4, 5, 3, 45, 61, 12, 62, 7, 49, 3, 41, 55, 46, \
58, 7, 14, 8, 55, 48, 13, 12, 48, 61, 43, 11, 13, 19, 5, 42, 64, 32, 8, 27, \
15, 49, 68, 8, 30, 42, 11, 30, 33}, {24, 1, 40, 33, 70, 9, 16, 21, 70, 5, 0, \
57, 49, 8, 48, 6, 11, 75, 13, 5, 17, 22, 7, 71, 21, 7, 2, 36, 72, 15, 75, 47, \
43, 37, 56, 42, 2, 46, 70, 2, 70, 35, 63, 57, 34, 48, 53, 35, 18, 49, 36, 46, \
29, 30, 14, 17, 42, 64, 50, 47, 53, 45, 19, 70, 70, 32, 60, 60, 66, 10, 56, \
20, 38, 0, 72, 67, 47, 8, 22, 47, 43, 18, 15, 70, 19, 71, 49, 41, 50, 70, 50, \
18, 33, 58, 68, 62, 48, 60, 9, 24}, {74, 25, 64, 35, 39, 23, 24, 53, 25, 65, \
51, 59, 65, 32, 15, 23, 48, 37, 8, 34, 31, 3, 69, 15, 38, 42, 62, 11, 4, 55, \
1, 32, 53, 7, 16, 34, 36, 20, 65, 68, 18, 27, 66, 51, 75, 29, 53, 22, 41, 61, \
4, 19, 3, 14, 67, 14, 57, 6, 28, 41, 70, 9, 23, 13, 47, 5, 65, 65, 22, 15, 6, \
60, 36, 27, 70, 46, 42, 68, 23, 37, 51, 60, 14, 34, 1, 61, 73, 63, 59, 26, 4, \
7, 25, 38, 22, 65, 15, 63, 47, 46}, {69, 62, 70, 38, 38, 18, 63, 12, 37, 35, \
47, 22, 52, 70, 46, 12, 64, 66, 25, 3, 2, 58, 69, 69, 60, 64, 59, 13, 59, 19, \
75, 15, 64, 34, 25, 50, 10, 1, 72, 52, 60, 1, 34, 40, 72, 62, 74, 54, 6, 18, \
63, 13, 67, 6, 47, 6, 17, 7, 20, 66, 13, 70, 8, 75, 5, 7, 19, 49, 42, 57, 19, \
42, 25, 32, 27, 28, 0, 65, 11, 51, 26, 13, 20, 59, 21, 55, 40, 39, 19, 52, \
41, 61, 55, 41, 27, 1, 12, 57, 29, 37}, {33, 55, 43, 75, 41, 10, 22, 39, 39, \
6, 21, 9, 3, 48, 56, 12, 34, 3, 75, 2, 65, 26, 21, 18, 35, 33, 47, 53, 69, \
66, 40, 54, 19, 15, 42, 54, 62, 9, 23, 70, 33, 15, 62, 38, 64, 74, 34, 23, \
64, 11, 60, 46, 63, 27, 59, 2, 21, 43, 18, 19, 67, 15, 63, 13, 19, 59, 4, 39, \
70, 34, 36, 67, 18, 27, 66, 23, 21, 14, 31, 12, 73, 55, 28, 16, 13, 6, 51, \
35, 68, 23, 46, 56, 28, 20, 59, 26, 30, 29, 59, 9}, {65, 19, 62, 36, 12, 33, \
5, 40, 36, 23, 27, 6, 38, 14, 57, 17, 10, 42, 56, 74, 7, 33, 15, 26, 28, 52, \
61, 62, 15, 37, 37, 3, 38, 33, 13, 66, 11, 23, 3, 44, 25, 57, 58, 58, 37, 72, \
40, 72, 5, 35, 28, 36, 65, 15, 59, 48, 34, 9, 0, 20, 27, 63, 41, 69, 49, 51, \
9, 71, 8, 55, 37, 50, 20, 66, 8, 32, 46, 43, 6, 26, 35, 10, 9, 47, 26, 24, \
26, 5, 42, 4, 9, 23, 39, 40, 69, 66, 13, 42, 26, 9}, {46, 60, 41, 67, 33, 60, \
32, 25, 9, 4, 10, 33, 65, 70, 33, 54, 52, 36, 10, 18, 39, 59, 51, 16, 19, 39, \
1, 28, 56, 24, 65, 11, 29, 66, 40, 42, 38, 22, 22, 24, 11, 34, 48, 25, 66, \
49, 48, 44, 34, 29, 34, 28, 61, 62, 59, 49, 28, 67, 29, 43, 11, 41, 18, 33, \
34, 40, 13, 17, 3, 73, 21, 3, 25, 70, 2, 39, 36, 65, 61, 45, 72, 25, 46, 18, \
14, 40, 37, 23, 39, 70, 27, 3, 54, 44, 37, 67, 0, 44, 8, 57}, {50, 9, 74, 8, \
6, 58, 46, 67, 63, 52, 10, 5, 52, 34, 41, 67, 4, 14, 75, 52, 29, 47, 1, 64, \
52, 55, 44, 55, 58, 69, 40, 52, 28, 65, 31, 0, 74, 16, 45, 54, 37, 14, 49, \
52, 2, 24, 4, 41, 5, 0, 39, 75, 6, 55, 59, 55, 39, 61, 3, 7, 73, 4, 13, 7, \
28, 21, 52, 37, 33, 41, 48, 16, 38, 14, 64, 42, 19, 43, 16, 6, 53, 50, 24, \
34, 49, 48, 66, 70, 17, 61, 8, 38, 62, 72, 21, 1, 40, 0, 74, 67}}]\
\>", 
"\<\
54   0    72   25   41   52   36   34   56   42   48   27   70   33   16 \
  0    22   22   56   2    21   39   24   33   11   58   38   37   30   2    \
54   43   19   6    58   20   8    36   70   26   26   30   34   25   60   6  \
  72   12   14   71   72   24   46   69   67   57   35   62   75   30   18   \
65   58   2    38   38   63   50   32   60   9    67   46   75   4    36   57 \
  24   22   0    55   50   4    20   26   44   28   61   69   48   44   27   \
56   12   22   9    58   24   36   17

54   31   35   29   10   64   73   20   66   51   30   64   64   17   57   11 \
  44   58   51   73   62   28   30   9    14   3    60   74   62   50   54   \
71   56   32   54   19   58   15   40   9    60   62   11   64   51   60   30 \
  42   14   46   56   58   10   70   27   70   0    36   26   22   43   53   \
72   6    26   7    40   18   74   69   19   17   15   8    37   11   71   36 \
  70   68   52   44   62   17   69   60   62   31   14   43   64   42   56   \
7    5    25   43   60   26   45

48   60   25   17   47   1    61   39   21   30   63   68   39   10   39   0  \
  12   35   49   60   51   71   32   4    58   49   27   16   16   69   49   \
4    48   74   65   55   45   52   75   48   33   9    11   9    69   37   61 \
  70   53   39   47   48   53   43   44   40   17   52   4    5    3    45   \
61   12   62   7    49   3    41   55   46   58   7    14   8    55   48   13 \
  12   48   61   43   11   13   19   5    42   64   32   8    27   15   49   \
68   8    30   42   11   30   33

24   1    40   33   70   9    16   21   70   5    0    57   49   8    48   6  \
  11   75   13   5    17   22   7    71   21   7    2    36   72   15   75   \
47   43   37   56   42   2    46   70   2    70   35   63   57   34   48   53 \
  35   18   49   36   46   29   30   14   17   42   64   50   47   53   45   \
19   70   70   32   60   60   66   10   56   20   38   0    72   67   47   8  \
  22   47   43   18   15   70   19   71   49   41   50   70   50   18   33   \
58   68   62   48   60   9    24

74   25   64   35   39   23   24   53   25   65   51   59   65   32   15   23 \
  48   37   8    34   31   3    69   15   38   42   62   11   4    55   1    \
32   53   7    16   34   36   20   65   68   18   27   66   51   75   29   53 \
  22   41   61   4    19   3    14   67   14   57   6    28   41   70   9    \
23   13   47   5    65   65   22   15   6    60   36   27   70   46   42   68 \
  23   37   51   60   14   34   1    61   73   63   59   26   4    7    25   \
38   22   65   15   63   47   46

69   62   70   38   38   18   63   12   37   35   47   22   52   70   46   12 \
  64   66   25   3    2    58   69   69   60   64   59   13   59   19   75   \
15   64   34   25   50   10   1    72   52   60   1    34   40   72   62   74 \
  54   6    18   63   13   67   6    47   6    17   7    20   66   13   70   \
8    75   5    7    19   49   42   57   19   42   25   32   27   28   0    65 \
  11   51   26   13   20   59   21   55   40   39   19   52   41   61   55   \
41   27   1    12   57   29   37

33   55   43   75   41   10   22   39   39   6    21   9    3    48   56   12 \
  34   3    75   2    65   26   21   18   35   33   47   53   69   66   40   \
54   19   15   42   54   62   9    23   70   33   15   62   38   64   74   34 \
  23   64   11   60   46   63   27   59   2    21   43   18   19   67   15   \
63   13   19   59   4    39   70   34   36   67   18   27   66   23   21   14 \
  31   12   73   55   28   16   13   6    51   35   68   23   46   56   28   \
20   59   26   30   29   59   9

65   19   62   36   12   33   5    40   36   23   27   6    38   14   57   17 \
  10   42   56   74   7    33   15   26   28   52   61   62   15   37   37   \
3    38   33   13   66   11   23   3    44   25   57   58   58   37   72   40 \
  72   5    35   28   36   65   15   59   48   34   9    0    20   27   63   \
41   69   49   51   9    71   8    55   37   50   20   66   8    32   46   43 \
  6    26   35   10   9    47   26   24   26   5    42   4    9    23   39   \
40   69   66   13   42   26   9

46   60   41   67   33   60   32   25   9    4    10   33   65   70   33   54 \
  52   36   10   18   39   59   51   16   19   39   1    28   56   24   65   \
11   29   66   40   42   38   22   22   24   11   34   48   25   66   49   48 \
  44   34   29   34   28   61   62   59   49   28   67   29   43   11   41   \
18   33   34   40   13   17   3    73   21   3    25   70   2    39   36   65 \
  61   45   72   25   46   18   14   40   37   23   39   70   27   3    54   \
44   37   67   0    44   8    57

50   9    74   8    6    58   46   67   63   52   10   5    52   34   41   67 \
  4    14   75   52   29   47   1    64   52   55   44   55   58   69   40   \
52   28   65   31   0    74   16   45   54   37   14   49   52   2    24   4  \
  41   5    0    39   75   6    55   59   55   39   61   3    7    73   4    \
13   7    28   21   52   37   33   41   48   16   38   14   64   42   19   43 \
  16   6    53   50   24   34   49   48   66   70   17   61   8    38   62   \
72   21   1    40   0    74   67\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
Next Alice encodes her message by first mapping each symbol in the \
message to the corresponding number for that symbol in the alphabet ...\
\>", 
  "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["MessageToIntegers[\"Telephone 555 1212!\", $Alphabet]", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, 53, 62}\
\
\>", "\<\
{45, 4, 11, 4, 15, 7, 14, 13, 4, 74, 56, 56, 56, 74, 52, 53, 52, \
53, 62}\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
... and then adding a random integer to that number modulo l. In \
this case the message contains 19 characters so Alice is using the first 19 \
integers on page 7 of her (and Bob's) key pad, $Pad. \
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Take[$Pad[[7]], {1, 19}]", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{33, 55, 43, 75, 41, 10, 22, 39, 39, 6, 21, 9, 3, 48, 56, 12, 34, 3, 75}\
\
\>", "\<\
{33, 55, 43, 75, 41, 10, 22, 39, 39, 6, 21, 9, 3, 48, 56, 12, 34, \
3, 75}\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
Using the first 19 integers on page 7 of the pad, Alice can encrypt \
a message:\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
cipher = EncryptOTP[\"Telephone 555 1212!\", 7, $Pad, \
$Alphabet]\
\>", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{2, 59, 54, 3, 56, 17, 36, 52, 43, 4, 1, 65, 59, 46, 32, 65, 10, 56, 61}\
\
\>", "\<\
{2, 59, 54, 3, 56, 17, 36, 52, 43, 4, 1, 65, 59, 46, 32, 65, 10, \
56, 61}\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell["\<\
Upon, receipt of an encrypted message, Bob must use the same set of \
keys that Alice used to encrypt the message to decrypt the message. In \
particular, Alice must tell Bob she used page 7 of the shared pad, so he can \
figure out what the random \"noise\" integers must have been. After \
unscrambling the message back to a sequence of integers, Bob then inverts the \
encoding of symbols as integers by calling IntegersToMessage (the inverse of \
MessageToIntegers). Bundling these steps together gives us DecryptOTP.\
\>", 
  "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["DecryptOTP[cipher, 7, $Pad, $Alphabet]", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
\"Telephone 555 1212!\"\
\>", 
"\<\
Telephone 555 1212!\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Frequency of Letters in English", "Section",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Frequency of letters in 1000 characters of English. Source - \
Dominic Welsh, \"Codes & Cryptography\", Oxford Science Publications  (1988), \
p231\
\>", "Text",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
Needs[\"Graphics`Graphics`\"];

freqInEnglishData =
{{\"a\", 1, 64},  {\"b\", 2, 14},  {\"c\", 3, 27},  {\"d\", 4, 35}, 
 {\"e\", 5, 100}, {\"f\", 6, 20},  {\"g\", 7, 14},  {\"h\", 8, 42}, 
 {\"i\", 9, 63},  {\"j\", 10, 3},  {\"k\", 11, 6},  {\"l\", 12, 35}, 
 {\"m\", 13, 20}, {\"n\", 14, 56}, {\"o\", 15, 56}, {\"p\", 16, 17}, 
 {\"q\", 17, 4},  {\"r\", 18, 49}, {\"s\", 19, 56}, {\"t\", 20, 71}, 
 {\"u\", 21, 31}, {\"v\", 22, 10}, {\"w\", 23, 18}, {\"x\", 24, 3}, 
 {\"y\", 25, 18}, {\"z\", 26, 2},  {\"_\", 27, 166}};

PlotFreqInEnglish[data_]:=
\tModule[{labels},
\t\tlabels = Map[#[[1]]&, data];
\t\tBarChart[Map[#[[3]]&, data],
\t\t         BarLabels->labels,
\t\t         BarSpacing->0.1,
\t\t         BarEdges->False,
\t\t         BarStyle->{GrayLevel[0.6]},
\t\t         PlotRange->All,
\t\t         Frame->True, Axes->False, GridLines->Automatic]
\t];

PlotFreqInEnglish[freqInEnglishData]\
\>", "Input",
  Editable->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.00062422 0.0356697 0.0147151 0.00354581 [
[(a)] .03629 0 0 2 Msboxa
[(b)] .07196 0 0 2 Msboxa
[(c)] .10763 0 0 2 Msboxa
[(d)] .1433 0 0 2 Msboxa
[(e)] .17897 0 0 2 Msboxa
[(f)] .21464 0 0 2 Msboxa
[(g)] .25031 0 0 2 Msboxa
[(h)] .28598 0 0 2 Msboxa
[(i)] .32165 0 0 2 Msboxa
[(j)] .35732 0 0 2 Msboxa
[(k)] .39299 0 0 2 Msboxa
[(l)] .42866 0 0 2 Msboxa
[(m)] .46433 0 0 2 Msboxa
[(n)] .5 0 0 2 Msboxa
[(o)] .53567 0 0 2 Msboxa
[(p)] .57134 0 0 2 Msboxa
[(q)] .60701 0 0 2 Msboxa
[(r)] .64268 0 0 2 Msboxa
[(s)] .67835 0 0 2 Msboxa
[(t)] .71402 0 0 2 Msboxa
[(u)] .74969 0 0 2 Msboxa
[(v)] .78536 0 0 2 Msboxa
[(w)] .82103 0 0 2 Msboxa
[(x)] .8567 0 0 2 Msboxa
[(y)] .89237 0 0 2 Msboxa
[(z)] .92804 0 0 2 Msboxa
[(_)] .96371 0 0 2 Msboxa
[(0)] -0.0125 .01472 1 0 Msboxa
[(25)] -0.0125 .10336 1 0 Msboxa
[(50)] -0.0125 .19201 1 0 Msboxa
[(75)] -0.0125 .28065 1 0 Msboxa
[(100)] -0.0125 .3693 1 0 Msboxa
[(125)] -0.0125 .45794 1 0 Msboxa
[(150)] -0.0125 .54659 1 0 Msboxa
[ -0.001 -0.001 0 0 ]
[ 1.001 .61903 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
p
0 0 .5 r
.001 w
.17897 0 m
.17897 .61803 L
s
P
p
0 0 .5 r
.001 w
.35732 0 m
.35732 .61803 L
s
P
p
0 0 .5 r
.001 w
.53567 0 m
.53567 .61803 L
s
P
p
0 0 .5 r
.001 w
.71402 0 m
.71402 .61803 L
s
P
p
0 0 .5 r
.001 w
.89237 0 m
.89237 .61803 L
s
P
p
0 0 .5 r
.001 w
0 .10336 m
1 .10336 L
s
P
p
0 0 .5 r
.001 w
0 .19201 m
1 .19201 L
s
P
p
0 0 .5 r
.001 w
0 .28065 m
1 .28065 L
s
P
p
0 0 .5 r
.001 w
0 .3693 m
1 .3693 L
s
P
p
0 0 .5 r
.001 w
0 .45794 m
1 .45794 L
s
P
p
0 0 .5 r
.001 w
0 .54659 m
1 .54659 L
s
P
p
.002 w
.03629 0 m
.03629 .00625 L
s
P
[(a)] .03629 0 0 2 Mshowa
p
.002 w
.07196 0 m
.07196 .00625 L
s
P
[(b)] .07196 0 0 2 Mshowa
p
.002 w
.10763 0 m
.10763 .00625 L
s
P
[(c)] .10763 0 0 2 Mshowa
p
.002 w
.1433 0 m
.1433 .00625 L
s
P
[(d)] .1433 0 0 2 Mshowa
p
.002 w
.17897 0 m
.17897 .00625 L
s
P
[(e)] .17897 0 0 2 Mshowa
p
.002 w
.21464 0 m
.21464 .00625 L
s
P
[(f)] .21464 0 0 2 Mshowa
p
.002 w
.25031 0 m
.25031 .00625 L
s
P
[(g)] .25031 0 0 2 Mshowa
p
.002 w
.28598 0 m
.28598 .00625 L
s
P
[(h)] .28598 0 0 2 Mshowa
p
.002 w
.32165 0 m
.32165 .00625 L
s
P
[(i)] .32165 0 0 2 Mshowa
p
.002 w
.35732 0 m
.35732 .00625 L
s
P
[(j)] .35732 0 0 2 Mshowa
p
.002 w
.39299 0 m
.39299 .00625 L
s
P
[(k)] .39299 0 0 2 Mshowa
p
.002 w
.42866 0 m
.42866 .00625 L
s
P
[(l)] .42866 0 0 2 Mshowa
p
.002 w
.46433 0 m
.46433 .00625 L
s
P
[(m)] .46433 0 0 2 Mshowa
p
.002 w
.5 0 m
.5 .00625 L
s
P
[(n)] .5 0 0 2 Mshowa
p
.002 w
.53567 0 m
.53567 .00625 L
s
P
[(o)] .53567 0 0 2 Mshowa
p
.002 w
.57134 0 m
.57134 .00625 L
s
P
[(p)] .57134 0 0 2 Mshowa
p
.002 w
.60701 0 m
.60701 .00625 L
s
P
[(q)] .60701 0 0 2 Mshowa
p
.002 w
.64268 0 m
.64268 .00625 L
s
P
[(r)] .64268 0 0 2 Mshowa
p
.002 w
.67835 0 m
.67835 .00625 L
s
P
[(s)] .67835 0 0 2 Mshowa
p
.002 w
.71402 0 m
.71402 .00625 L
s
P
[(t)] .71402 0 0 2 Mshowa
p
.002 w
.74969 0 m
.74969 .00625 L
s
P
[(u)] .74969 0 0 2 Mshowa
p
.002 w
.78536 0 m
.78536 .00625 L
s
P
[(v)] .78536 0 0 2 Mshowa
p
.002 w
.82103 0 m
.82103 .00625 L
s
P
[(w)] .82103 0 0 2 Mshowa
p
.002 w
.8567 0 m
.8567 .00625 L
s
P
[(x)] .8567 0 0 2 Mshowa
p
.002 w
.89237 0 m
.89237 .00625 L
s
P
[(y)] .89237 0 0 2 Mshowa
p
.002 w
.92804 0 m
.92804 .00625 L
s
P
[(z)] .92804 0 0 2 Mshowa
p
.002 w
.96371 0 m
.96371 .00625 L
s
P
[(_)] .96371 0 0 2 Mshowa
p
.002 w
0 0 m
1 0 L
s
P
p
.002 w
0 .01472 m
.00625 .01472 L
s
P
[(0)] -0.0125 .01472 1 0 Mshowa
p
.002 w
0 .10336 m
.00625 .10336 L
s
P
[(25)] -0.0125 .10336 1 0 Mshowa
p
.002 w
0 .19201 m
.00625 .19201 L
s
P
[(50)] -0.0125 .19201 1 0 Mshowa
p
.002 w
0 .28065 m
.00625 .28065 L
s
P
[(75)] -0.0125 .28065 1 0 Mshowa
p
.002 w
0 .3693 m
.00625 .3693 L
s
P
[(100)] -0.0125 .3693 1 0 Mshowa
p
.002 w
0 .45794 m
.00625 .45794 L
s
P
[(125)] -0.0125 .45794 1 0 Mshowa
p
.002 w
0 .54659 m
.00625 .54659 L
s
P
[(150)] -0.0125 .54659 1 0 Mshowa
p
.001 w
0 .03244 m
.00375 .03244 L
s
P
p
.001 w
0 .05017 m
.00375 .05017 L
s
P
p
.001 w
0 .0679 m
.00375 .0679 L
s
P
p
.001 w
0 .08563 m
.00375 .08563 L
s
P
p
.001 w
0 .12109 m
.00375 .12109 L
s
P
p
.001 w
0 .13882 m
.00375 .13882 L
s
P
p
.001 w
0 .15655 m
.00375 .15655 L
s
P
p
.001 w
0 .17428 m
.00375 .17428 L
s
P
p
.001 w
0 .20973 m
.00375 .20973 L
s
P
p
.001 w
0 .22746 m
.00375 .22746 L
s
P
p
.001 w
0 .24519 m
.00375 .24519 L
s
P
p
.001 w
0 .26292 m
.00375 .26292 L
s
P
p
.001 w
0 .29838 m
.00375 .29838 L
s
P
p
.001 w
0 .31611 m
.00375 .31611 L
s
P
p
.001 w
0 .33384 m
.00375 .33384 L
s
P
p
.001 w
0 .35157 m
.00375 .35157 L
s
P
p
.001 w
0 .38702 m
.00375 .38702 L
s
P
p
.001 w
0 .40475 m
.00375 .40475 L
s
P
p
.001 w
0 .42248 m
.00375 .42248 L
s
P
p
.001 w
0 .44021 m
.00375 .44021 L
s
P
p
.001 w
0 .47567 m
.00375 .47567 L
s
P
p
.001 w
0 .4934 m
.00375 .4934 L
s
P
p
.001 w
0 .51113 m
.00375 .51113 L
s
P
p
.001 w
0 .52886 m
.00375 .52886 L
s
P
p
.001 w
0 .56432 m
.00375 .56432 L
s
P
p
.001 w
0 .58204 m
.00375 .58204 L
s
P
p
.001 w
0 .59977 m
.00375 .59977 L
s
P
p
.001 w
0 .6175 m
.00375 .6175 L
s
P
p
.002 w
0 0 m
0 .61803 L
s
P
P
p
p
.002 w
.03629 .61178 m
.03629 .61803 L
s
P
p
.002 w
.07196 .61178 m
.07196 .61803 L
s
P
p
.002 w
.10763 .61178 m
.10763 .61803 L
s
P
p
.002 w
.1433 .61178 m
.1433 .61803 L
s
P
p
.002 w
.17897 .61178 m
.17897 .61803 L
s
P
p
.002 w
.21464 .61178 m
.21464 .61803 L
s
P
p
.002 w
.25031 .61178 m
.25031 .61803 L
s
P
p
.002 w
.28598 .61178 m
.28598 .61803 L
s
P
p
.002 w
.32165 .61178 m
.32165 .61803 L
s
P
p
.002 w
.35732 .61178 m
.35732 .61803 L
s
P
p
.002 w
.39299 .61178 m
.39299 .61803 L
s
P
p
.002 w
.42866 .61178 m
.42866 .61803 L
s
P
p
.002 w
.46433 .61178 m
.46433 .61803 L
s
P
p
.002 w
.5 .61178 m
.5 .61803 L
s
P
p
.002 w
.53567 .61178 m
.53567 .61803 L
s
P
p
.002 w
.57134 .61178 m
.57134 .61803 L
s
P
p
.002 w
.60701 .61178 m
.60701 .61803 L
s
P
p
.002 w
.64268 .61178 m
.64268 .61803 L
s
P
p
.002 w
.67835 .61178 m
.67835 .61803 L
s
P
p
.002 w
.71402 .61178 m
.71402 .61803 L
s
P
p
.002 w
.74969 .61178 m
.74969 .61803 L
s
P
p
.002 w
.78536 .61178 m
.78536 .61803 L
s
P
p
.002 w
.82103 .61178 m
.82103 .61803 L
s
P
p
.002 w
.8567 .61178 m
.8567 .61803 L
s
P
p
.002 w
.89237 .61178 m
.89237 .61803 L
s
P
p
.002 w
.92804 .61178 m
.92804 .61803 L
s
P
p
.002 w
.96371 .61178 m
.96371 .61803 L
s
P
p
.002 w
0 .61803 m
1 .61803 L
s
P
p
.002 w
.99375 .01472 m
1 .01472 L
s
P
p
.002 w
.99375 .10336 m
1 .10336 L
s
P
p
.002 w
.99375 .19201 m
1 .19201 L
s
P
p
.002 w
.99375 .28065 m
1 .28065 L
s
P
p
.002 w
.99375 .3693 m
1 .3693 L
s
P
p
.002 w
.99375 .45794 m
1 .45794 L
s
P
p
.002 w
.99375 .54659 m
1 .54659 L
s
P
p
.001 w
.99625 .03244 m
1 .03244 L
s
P
p
.001 w
.99625 .05017 m
1 .05017 L
s
P
p
.001 w
.99625 .0679 m
1 .0679 L
s
P
p
.001 w
.99625 .08563 m
1 .08563 L
s
P
p
.001 w
.99625 .12109 m
1 .12109 L
s
P
p
.001 w
.99625 .13882 m
1 .13882 L
s
P
p
.001 w
.99625 .15655 m
1 .15655 L
s
P
p
.001 w
.99625 .17428 m
1 .17428 L
s
P
p
.001 w
.99625 .20973 m
1 .20973 L
s
P
p
.001 w
.99625 .22746 m
1 .22746 L
s
P
p
.001 w
.99625 .24519 m
1 .24519 L
s
P
p
.001 w
.99625 .26292 m
1 .26292 L
s
P
p
.001 w
.99625 .29838 m
1 .29838 L
s
P
p
.001 w
.99625 .31611 m
1 .31611 L
s
P
p
.001 w
.99625 .33384 m
1 .33384 L
s
P
p
.001 w
.99625 .35157 m
1 .35157 L
s
P
p
.001 w
.99625 .38702 m
1 .38702 L
s
P
p
.001 w
.99625 .40475 m
1 .40475 L
s
P
p
.001 w
.99625 .42248 m
1 .42248 L
s
P
p
.001 w
.99625 .44021 m
1 .44021 L
s
P
p
.001 w
.99625 .47567 m
1 .47567 L
s
P
p
.001 w
.99625 .4934 m
1 .4934 L
s
P
p
.001 w
.99625 .51113 m
1 .51113 L
s
P
p
.001 w
.99625 .52886 m
1 .52886 L
s
P
p
.001 w
.99625 .56432 m
1 .56432 L
s
P
p
.001 w
.99625 .58204 m
1 .58204 L
s
P
p
.001 w
.99625 .59977 m
1 .59977 L
s
P
p
.001 w
.99625 .6175 m
1 .6175 L
s
P
p
.002 w
1 0 m
1 .61803 L
s
P
P
p
P
p
p
p
.6 g
.02381 .01472 m
.02381 .24165 L
.04878 .24165 L
.04878 .01472 L
F
P
p
P
P
p
p
.6 g
.05948 .01472 m
.05948 .06436 L
.08445 .06436 L
.08445 .01472 L
F
P
p
P
P
p
p
.6 g
.09515 .01472 m
.09515 .11045 L
.12012 .11045 L
.12012 .01472 L
F
P
p
P
P
p
p
.6 g
.13082 .01472 m
.13082 .13882 L
.15579 .13882 L
.15579 .01472 L
F
P
p
P
P
p
p
.6 g
.16649 .01472 m
.16649 .3693 L
.19146 .3693 L
.19146 .01472 L
F
P
p
P
P
p
p
.6 g
.20216 .01472 m
.20216 .08563 L
.22713 .08563 L
.22713 .01472 L
F
P
p
P
P
p
p
.6 g
.23783 .01472 m
.23783 .06436 L
.2628 .06436 L
.2628 .01472 L
F
P
p
P
P
p
p
.6 g
.2735 .01472 m
.2735 .16364 L
.29847 .16364 L
.29847 .01472 L
F
P
p
P
P
p
p
.6 g
.30917 .01472 m
.30917 .2381 L
.33414 .2381 L
.33414 .01472 L
F
P
p
P
P
p
p
.6 g
.34484 .01472 m
.34484 .02535 L
.36981 .02535 L
.36981 .01472 L
F
P
p
P
P
p
p
.6 g
.38051 .01472 m
.38051 .03599 L
.40548 .03599 L
.40548 .01472 L
F
P
p
P
P
p
p
.6 g
.41618 .01472 m
.41618 .13882 L
.44114 .13882 L
.44114 .01472 L
F
P
p
P
P
p
p
.6 g
.45185 .01472 m
.45185 .08563 L
.47681 .08563 L
.47681 .01472 L
F
P
p
P
P
p
p
.6 g
.48752 .01472 m
.48752 .21328 L
.51248 .21328 L
.51248 .01472 L
F
P
p
P
P
p
p
.6 g
.52319 .01472 m
.52319 .21328 L
.54815 .21328 L
.54815 .01472 L
F
P
p
P
P
p
p
.6 g
.55886 .01472 m
.55886 .07499 L
.58382 .07499 L
.58382 .01472 L
F
P
p
P
P
p
p
.6 g
.59452 .01472 m
.59452 .0289 L
.61949 .0289 L
.61949 .01472 L
F
P
p
P
P
p
p
.6 g
.63019 .01472 m
.63019 .18846 L
.65516 .18846 L
.65516 .01472 L
F
P
p
P
P
p
p
.6 g
.66586 .01472 m
.66586 .21328 L
.69083 .21328 L
.69083 .01472 L
F
P
p
P
P
p
p
.6 g
.70153 .01472 m
.70153 .26647 L
.7265 .26647 L
.7265 .01472 L
F
P
p
P
P
p
p
.6 g
.7372 .01472 m
.7372 .12464 L
.76217 .12464 L
.76217 .01472 L
F
P
p
P
P
p
p
.6 g
.77287 .01472 m
.77287 .05017 L
.79784 .05017 L
.79784 .01472 L
F
P
p
P
P
p
p
.6 g
.80854 .01472 m
.80854 .07854 L
.83351 .07854 L
.83351 .01472 L
F
P
p
P
P
p
p
.6 g
.84421 .01472 m
.84421 .02535 L
.86918 .02535 L
.86918 .01472 L
F
P
p
P
P
p
p
.6 g
.87988 .01472 m
.87988 .07854 L
.90485 .07854 L
.90485 .01472 L
F
P
p
P
P
p
p
.6 g
.91555 .01472 m
.91555 .02181 L
.94052 .02181 L
.94052 .01472 L
F
P
p
P
P
p
p
.6 g
.95122 .01472 m
.95122 .60332 L
.97619 .60332 L
.97619 .01472 L
F
P
p
P
P
P
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{282, 174},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004J0000[Q000`40O003h00Oogoo2goo1P002Woo
001FOol3000GOol3000cOol40008Ool40012Ool3000OOol005Uoo`03001oogoo01Moo`03001oogoo
035oo`03001oogoo00Yoo`03001oogoo049oo`03001oogoo01ioo`007Woo1@0017oo10001Woo0`00
1Woo1@001Goo100017oo10001Woo100017oo0P0000=oo`00000017oo1@001goo00<007ooOol00goo
00@007oo000000Eoo`D000Aoo`05001oo`00Ool00004Ool200000goo00000006Ool30005Ool40006
Ool40004Ool40005Ool40006Ool30005Ool50005Ool20006Ool01000Oomoo`001Goo0P0000=oo`00
00001Woo00<007ooOol01Goo100057oo000NOol01000Oomoo`001Goo00D007ooOomoo`0000Aoo`05
001oogooOol00004Ool01@00Oomoogoo00001Goo00<007ooOol01goo00<007ooOol01Goo00D007oo
Oomoo`0000Aoo`04001oogoo0007Ool00`00Oomoo`07Ool00`00Oomoo`03Ool00`00Ool00008Ool0
0`00Oomoo`04Ool01@00Ool007oo000017oo00@007ooOol000Ioo`05001oogooOol00004Ool01@00
Oomoogoo000017oo00D007ooOomoo`0000Eoo`03001oogoo00Qoo`03001oogoo00Aoo`04001oogoo
0004Ool01000Oomoo`001Woo0P001Woo10001Woo00<007oo00001goo00<007ooOol01Woo00<007oo
Ool057oo000NOol40005Ool01@00Oomoogoo000017oo00<007ooOol01Woo00D007ooOomoo`0000Eo
o`D000Eoo`03001oogoo00Eoo`05001oogooOol00004Ool01000Oomoo`001goo00<007ooOol01goo
00<007ooOol00goo0`0027oo00<007ooOol017oo00D007oo001oo`0000Aoo`04001oogoo0006Ool0
1@00Oomoogoo000017oo00D007ooOomoo`0000Aoo`05001oogooOol00005Ool00`00Oomoo`05Ool4
0006Ool00`00Oomoo`05Ool01000Oomoo`001Goo00@007oo000000Eoo`@000Moo`03001oogoo00Eo
o`03001oo`0000Moo`8001Eoo`008Goo00<007ooOol00goo00D007ooOomoo`0000Aoo`05001oogoo
Ool00004Ool01@00Oomoogoo00001Goo00D007ooOomoo`0000Eoo`03001oogoo00Eoo`05001oogoo
Ool00004Ool01000Oomoo`001goo00<007ooOol01goo00<007ooOol00goo00<007oo000027oo00<0
07ooOol017oo00D007oo001oo`0000Aoo`04001oogoo0006Ool01@00Oomoogoo000017oo00D007oo
Oomoo`0000Aoo`05001oogooOol00005Ool20006Ool00`00Oomoo`07Ool00`00Oomoo`05Ool01000
Oomoo`001Goo00@007ooOol000Eoo`04001oogoo0006Ool00`00Ool00006Ool00`00Ool00008Ool0
0`00Oomoo`0COol001moo`<000Eoo`@000Ioo`@000Eoo`@000Ioo`<000Eoo`@000Ioo`D000=oo`@0
00Ioo`8000Ioo`@000Eoo`04001oo`000007Ool00`00Oomoo`03Ool60003Ool50007Ool30004Ool5
0006Ool50003Ool200000goo00000004Ool40005Ool40004Ool200000goo00000004Ool20002Ool2
0003Ool20002Ool20004Ool200000goo00000004Ool200000goo00000005Ool4000DOol002Moo`03
001oogoo01=oo`03001oogoo00eoo`03001oogoo00ioo`03001oogoo01Qoo`03001oogoo00Qoo`03
001oogoo04Eoo`03001oogoo04]oo`009Woo0P0057oo0P003goo0`003Goo0P002Woo00<007ooOol0
1goo00<007ooOol00Woo0P0027oo0`00Agoo00<007ooOol0Bgoo003oOolKOol00?mooa]oo`00ogoo
6goo003oOolKOol00?mooa]oo`005gooo`000@000goo000GOol00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06
Ool00`00Oomoo`06Ool00`00Oomoo`01Ool0011oo`8000Eoo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo00Moo`03001oogoo00Ioo`03001oogoo00Ioo`03001oogoo00Io
o`03001oogoo00Ioo`03001oogoo005oo`003goo00@007ooOol000Aoo`03001oogoo02]oo`0300mo
ogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo01Qoo`03001o
ogoo005oo`003goo00@007ooOol000Aoo`8002aoo`0300moogoo02Yoo`0300moogoo02]oo`0300mo
ogoo02Yoo`0300moogoo02]oo`0300moogoo01Ioo`<000=oo`003goo00@007ooOol000Aoo`03001o
ogoo00=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`=oo`I>L`=oo`I>L`=oo`I>L`=o
o`I>L`=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`=oo`I>L`=oo`I>L`=oo`I>L`=o
o`I>L`=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`=oo`I>L`=oo`I>L`Ioo`03001oogoo005o
o`003goo00@007ooOol000Aoo`03001oogoo00=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9o
o`M>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9o
o`M>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`=o
o`I>L`=oo`I>L`Ioo`03001oogoo005oo`0047oo0P001Goo00<007ooOol00goo1Tic0goo1Tic0goo
1dic0Woo1dic0Woo1dic0Woo1dic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo
1dic0Woo1dic0Woo1dic0Woo1dic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo
1dic0Woo1dic0Woo1dic37oo1Tic1Woo00<007ooOol00Goo000GOol00`00Oomoo`03Ool6CW<3Ool6
CW<3Ool7CW<2Ool7CW<2Ool7CW<2Ool7CW<3Ool6CW<3Ool6CW<3Ool6CW<6Ool00`0?Oomoo`03Ool6
CW<3Ool6CW<3Ool7CW<2Ool7CW<2Ool7CW<2Ool7CW<3Ool6CW<3Ool6CW<3Ool6CW<3Ool6CW<3Ool6
CW<3Ool6CW<3Ool7CW<;Ool7CW<<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`8000Aoo`I>L`=oo`I>
L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`=oo`I>L`=oo`I>L`=oo`I>L`Ioo`0300moogoo00=oo`I>
L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`aoo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>
L`=oo`M>L`]oo`M>L`aoo`I>L`Eoo`8000=oo`005goo00<007ooOol00goo1Tic0goo1Tic0goo1dic
0Woo1dic0Woo1dic0Woo1dic0goo1Tic0goo1Tic0goo1Tic1Woo00<03gooOol00goo1Tic0goo1Tic
0goo1dic0Woo1dic0Woo1dic0Woo1dic37oo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1dic
2goo1dic37oo1Tic1Woo00<007ooOol00Goo000GOol00`00Oomoo`03Ool6CW<3Ool6CW<3Ool7CW<2
Ool7CW<2Ool7CW<2Ool7CW<3Ool6CW<3Ool6CW<3Ool6CW<6Ool00`0?Oomoo`0<Ool6CW<3Ool7CW<2
Ool7CW<2Ool7CW<2Ool7CW<<Ool6CW<3Ool6CW<3Ool6CW<3Ool6CW<3Ool6CW<3Ool7CW<;Ool7CW<<
Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo00=oo`I>L`=oo`I>L`=oo`M>L`9oo`M>L`9o
o`M>L`9oo`M>L`=oo`I>L`=oo`I>L`=oo`I>L`Ioo`0300moogoo00aoo`I>L`=oo`M>L`9oo`M>L`9o
o`M>L`9oo`M>L`aoo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`=oo`M>L`]oo`M>L`aoo`I>L`Io
o`03001oogoo005oo`005goo0P0017oo1Tic0goo1Tic0goo1dic0Woo1dic0Woo1dic0Woo1dic0goo
1Tic0goo1Tic0goo1Tic1Woo00<03gooOol037oo1Tic0goo1dic0Woo1dic0Woo1dic0Woo1dic37oo
1Tic0goo1Tic0goo1Tic0goo1Tic0goo1Tic0goo1dic2goo1dic37oo1Tic1Goo0P000goo000GOol0
0`00Oomoo`03Ool6CW<3Ool6CW<3Ool7CW<2Ool7CW<2Ool7CW<2Ool7CW<3Ool6CW<3Ool6CW<3Ool6
CW<6Ool00`0?Oomoo`0<Ool6CW<3Ool7CW<2Ool7CW<2Ool7CW<2Ool7CW<<Ool6CW<3Ool6CW<3Ool6
CW<3Ool6CW<<Ool7CW<;Ool7CW<<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo00=oo`I>
L`=oo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`=oo`I>L`=oo`I>L`=oo`I>L`Ioo`0300moogoo
00aoo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`aoo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`aoo`M>
L`]oo`M>L`aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol00goo1Tic0goo1Tic0goo1dic
0Woo1dic0Woo1dic0Woo1dic0goo1Tic0goo1Tic0goo1Tic1Woo00<03gooOol037oo1Tic0goo1dic
0Woo1dic0Woo1dic0Woo1dic37oo1Tic0goo1Tic0goo1Tic0goo1Tic37oo1dic2goo1dic37oo1Tic
1Woo00<007ooOol00Goo000GOol00`00Oomoo`03Ool6CW<3Ool6CW<3Ool7CW<2Ool7CW<2Ool7CW<2
Ool7CW<3Ool6CW<3Ool6CW<3Ool6CW<6Ool00`0?Oomoo`0<Ool6CW<3Ool7CW<2Ool7CW<2Ool7CW<2
Ool7CW<<Ool6CW<3Ool6CW<3Ool6CW<3Ool6CW<<Ool7CW<;Ool7CW<<Ool6CW<6Ool00`00Oomoo`01
Ool001Moo`8000Aoo`I>L`aoo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`aoo`I>L`=oo`I>L`Ioo`0300mo
ogoo00aoo`I>L`=oo`M>L`9oo`M>L`9oo`M>L`9oo`M>L`aoo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`ao
o`M>L`]oo`M>L`aoo`I>L`Eoo`8000=oo`005goo00<007ooOol00goo1Tic37oo1dic0Woo1dic0Woo
1dic0Woo1dic37oo1Tic0goo1Tic1Woo00<03gooOol037oo1Tic0goo1dic0Woo1dic0Woo1dic0Woo
1dic37oo1Tic0goo1Tic0goo1Tic0goo1Tic37oo1dic2goo1dic37oo1Tic1Woo00<007ooOol00Goo
000GOol00`00Oomoo`03Ool6CW<<Ool7CW<2Ool7CW<2Ool7CW<2Ool7CW<<Ool6CW<3Ool6CW<6Ool0
0`0?Oomoo`0<Ool6CW<3Ool7CW<2Ool7CW<2Ool7CW<2Ool7CW<<Ool6CW<3Ool6CW<3Ool6CW<3Ool6
CW<<Ool7CW<;Ool7CW<<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo00=oo`I>L`aoo`M>
L`9oo`M>L`9oo`M>L`9oo`M>L`aoo`I>L`=oo`I>L`Ioo`0300moogoo00aoo`I>L`=oo`M>L`9oo`M>
L`9oo`M>LaEoo`I>L`=oo`I>L`=oo`I>L`=oo`I>L`aoo`M>L`]oo`M>L`aoo`I>L`Ioo`03001oogoo
005oo`005goo0P0017oo1Tic37oo1dic0Woo1dic0Woo1dic0Woo1dic37oo1Tic0goo1Tic1Woo00<0
3gooOol037oo1Tic0goo1dic0Woo1dic0Woo1dic5Goo1Tic0goo1Tic0goo1Tic0goo1Tic8Woo00<0
3gooOol037oo1Tic1Goo0P000goo000GOol00`00Oomoo`03Ool6CW<<Ool7CW<2Ool7CW<2Ool7CW<E
Ool6CW<3Ool6CW<6Ool00`0?Oomoo`0<Ool6CW<<Ool7CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<3
Ool6CW<ROol00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo00=oo`I>L`ao
o`M>L`9oo`M>L`9oo`M>LaEoo`I>L`=oo`I>L`Ioo`0300moogoo00aoo`I>L`aoo`M>L`9oo`M>LaEo
o`I>L`=oo`I>L`=oo`I>L`=oo`I>Lb9oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`002Goo
10000Woo0`001Goo00<007ooOol00goo1Tic37oo1dic0Woo1dic0Woo1dic5Goo1Tic0goo1Tic1Woo
00<03gooOol037oo1Tic37oo1dic0Woo1dic5Goo1Tic0goo1Tic0goo1Tic0goo1Tic8Woo00<03goo
Ool037oo1Tic1Woo00<007ooOol00Goo000:Ool00`00Oomoo`05Ool00`00Oomoo`02Ool00`00Oomo
o`03Ool6CW<<Ool7CW<2Ool7CW<2Ool7CW<EOol6CW<3Ool6CW<6Ool00`0?Oomoo`0<Ool6CW<<Ool7
CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<3Ool6CW<ROol00`0?Oomoo`0<Ool6CW<6Ool00`00Oomo
o`01Ool000]oo`03001oogoo00Aoo`03001oogoo009oo`8000@03`I>L``03`M>L`803`M>L`803`M>
LaD03`I>L`<03`I>LaD03`I>L``03`M>L`803`M>LaD03`I>L`<03`I>L`<03`I>L`<03`I>Lc403`I>
L`@03`<000=oo`0037oo00<007ooOol00`001Goo00<007ooOol00goo1Tic37oo1dic0Woo1dic0Woo
1dic5Goo1Tic0goo1Tic1Woo00<03gooOol037oo1Tic37oo1dic0Woo1dic5Goo1Tic0goo1Tic0goo
1Tic0goo1Tic8Woo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0009Ool01000Oomoo`000Woo
00<007ooOol01Goo00<007ooOol00goo1Tic37oo1dic0Woo1dic0Woo1dic5Goo1Tic0goo1Tic1Woo
00<03gooOol037oo1Tic37oo1dic0Woo1dic5Goo1Tic0goo1Tic0goo1Tic0goo1Tic8Woo00<03goo
Ool037oo1Tic1Woo00<007ooOol00Goo000:Ool20003Ool40004Ool00`00Oomoo`03Ool6CW<EOol7
CW<2Ool7CW<EOol6CW<3Ool6CW<6Ool00`0?Oomoo`0<Ool6CW<<Ool7CW<2Ool7CW<EOol6CW<3Ool6
CW<3Ool6CW<3Ool6CW<ROol00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`8000Aoo`I>
LaEoo`M>L`9oo`M>LaEoo`I>L`=oo`I>L`Ioo`0300moogoo00aoo`I>L`aoo`M>L`9oo`M>LaEoo`I>
L`=oo`I>L`=oo`I>L`=oo`I>Lb9oo`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<007ooOol0
0goo1Tic5Goo1dic0Woo1dic5Goo1Tic0goo1Tic1Woo00<03gooOol037oo1Tic37oo1dic0Woo1dic
5Goo1Tic0goo1Tic0goo1Tic0goo1Tic8Woo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000G
Ool00`00Oomoo`03Ool6CW<EOol7CW<2Ool7CW<EOol6CW<3Ool6CW<6Ool00`0?Oomoo`0<Ool6CW<<
Ool7CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01
Ool001Moo`03001oogoo00=oo`I>LaEoo`M>L`9oo`M>LaEoo`I>L`=oo`I>L`Ioo`0300moogoo00ao
o`I>L`aoo`M>L`9oo`M>LaEoo`I>L`=oo`I>L`=oo`I>Lb]oo`0300moogoo00aoo`I>L`Ioo`03001o
ogoo005oo`005goo00<007ooOol00goo1Tic5Goo1dic0Woo1dic5Goo1Tic0goo1Tic1Woo00<03goo
Ool037oo1Tic37oo1dic0Woo1dic5Goo1Tic0goo1Tic0goo1Tic:goo00<03gooOol037oo1Tic1Woo
00<007ooOol00Goo000GOol20004Ool6CW<EOol7CW<2Ool7CW<EOol6CW<3Ool6CW<6Ool00`0?Oomo
o`0<Ool6CW<<Ool7CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<5Ool2
0003Ool001Moo`03001oogoo00=oo`I>Laioo`M>LaEoo`I>L`=oo`I>L`Ioo`0300moogoo01ioo`M>
L`9oo`M>LaEoo`I>L`=oo`I>L`=oo`I>Lb]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`00
5goo00<007ooOol00goo1Tic7Woo1dic5Goo1Tic0goo1Tic1Woo00<03gooOol07Woo1dic0Woo1dic
5Goo1Tic0goo1Tic0goo1Tic:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol00`00
Oomoo`03Ool6CW<NOol7CW<EOol6CW<3Ool6CW<6Ool00`0?Oomoo`0NOol7CW<2Ool7CW<EOol6CW<3
Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`8000Aoo`I>Laio
o`M>LaEoo`I>L`=oo`I>L`Ioo`0300moogoo01ioo`M>L`9oo`M>LaEoo`I>L`=oo`I>L`=oo`I>Lb]o
o`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<007ooOol00goo1Tic7Woo1dic5Goo1Tic0goo
1Tic1Woo00<03gooOol07Woo1dic0Woo1dic5Goo1Tic0goo1Tic0goo1Tic:goo00<03gooOol037oo
1Tic1Woo00<007ooOol00Goo000GOol00`00Oomoo`03Ool6CW<NOol7CW<EOol6CW<3Ool6CW<6Ool0
0`0?Oomoo`0NOol7CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool0
0`00Oomoo`01Ool001Moo`03001oogoo00=oo`I>Laioo`M>Laioo`I>L`Ioo`0300moogoo01ioo`M>
L`9oo`M>LaEoo`I>L`=oo`I>L`=oo`I>Lb]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`00
5goo00<007ooOol00goo1Tic7Woo1dic7Woo1Tic1Woo00<03gooOol07Woo1dic0Woo1dic5Goo1Tic
0goo1Tic0goo1Tic:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol20004Ool6CW<N
Ool7CW<NOol6CW<6Ool00`0?Oomoo`0NOol7CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<[Ool00`0?
Oomoo`0<Ool6CW<5Ool20003Ool001Moo`03001oogoo00=oo`I>Laioo`M>Laioo`I>L`Ioo`0300mo
ogoo01ioo`M>L`9oo`M>LaEoo`I>L`=oo`I>L`=oo`I>Lb]oo`0300moogoo00aoo`I>L`Ioo`03001o
ogoo005oo`005goo00<007ooOol00goo1Tic7Woo1dic7Woo1Tic1Woo00<03gooOol07Woo1dic0Woo
1dic5Goo1Tic0goo1Tic0goo1Tic:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0009Ool3
0004Ool20005Ool00`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6Ool00`0?Oomoo`0NOol7CW<2Ool7
CW<EOol6CW<3Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000aoo`04
001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6Ool00`0?Oomo
o`0NOol7CW<2Ool7CW<EOol6CW<3Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomo
o`01Ool000aoo`04001oogoo0002Ool00`00Oomoo`02Ool2000400l6CW<N00l7CW<N00l6CW<W00l7
CW<200l7CW<N00l6CW<300l6CW<j00l6CW<400l30003Ool000Uoo`<000=oo`04001oogoo0004Ool0
0`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6Ool00`0?Oomoo`0NOol7CW<2Ool7CW<NOol6CW<3Ool6
CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000Uoo`03001oogoo00=oo`04001oogoo
0004Ool00`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6Ool00`0?Oomoo`0NOol7CW<2Ool7CW<NOol6
CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000Uoo`@000=oo`8000Eoo`03
001oogoo00=oo`I>Laioo`M>Laioo`I>L`Ioo`0300moogoo01ioo`M>L`9oo`M>Laioo`I>L`=oo`I>
Lb]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo0P0017oo1Tic7Woo1dic7Woo1Tic
1Woo00<03gooOol07Woo1dic0Woo1dic7Woo1Tic0goo1Tic:goo00<03gooOol037oo1Tic1Goo0P00
0goo000GOol00`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6Ool00`0?Oomoo`0NOol7CW<2Ool7CW<N
Ool6CW<3Ool6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo00=o
o`I>Laioo`M>Laioo`I>L`Ioo`0300moogoo02]oo`0300moogoo02Moo`I>Lb]oo`0300moogoo00ao
o`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol00goo1Tic7Woo1dic7Woo1Tic1Woo00<03goo
Ool0:goo00<03gooOol09goo1Tic:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol0
0`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6Ool00`0?Oomoo`0[Ool00`0?Oomoo`0WOol6CW<[Ool0
0`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`8000Aoo`I>Laioo`M>Laioo`I>L`Ioo`03
00moogoo02]oo`0300moogoo02Moo`I>Lb]oo`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<0
07ooOol00goo1Tic7Woo1dic7Woo1Tic1Woo00<03gooOol0:goo00<03gooOol09goo1Tic:goo00<0
3gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol00`00Oomoo`03Ool6CW<NOol7CW<NOol6CW<6
Ool00`0?Oomoo`0[Ool00`0?Oomoo`0WOol6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01
Ool001Moo`03001oogoo00=oo`I>Laioo`M>LbYoo`0300moogoo02]oo`0300moogoo02Moo`I>Lb]o
o`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo0P00:7oo1dic:Woo00<03gooOol0:goo
00<03gooOol09goo1Tic:goo00<03gooOol037oo1Tic1Goo0P000goo000GOol00`00Oomoo`0WOol7
CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0WOol6CW<[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomo
o`01Ool001Moo`03001oogoo02Moo`M>LbYoo`0300moogoo02]oo`0300moogoo02Moo`I>Lb]oo`03
00moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol09goo1dic:Woo00<03gooOol0
:goo00<03gooOol09goo1Tic:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol00`00
Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0WOol6CW<[Ool00`0?Oomoo`0<Ool6CW<6
Ool00`00Oomoo`01Ool001Moo`8002Qoo`M>LbYoo`0300moogoo02]oo`0300moogoo02Moo`I>Lb]o
o`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<007ooOol09goo1dic:Woo00<03gooOol0:goo
00<03gooOol09goo1Tic:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000:Ool00`00Oomo
o`02Ool30005Ool00`00Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomo
o`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000Yoo`03001oogoo00Eoo`03001oogoo
009oo`03001oogoo02Moo`M>LbYoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`03
00moogoo00aoo`I>L`Ioo`03001oogoo005oo`002goo00<007ooOol017oo00<007ooOol00Woo0P00
:00?1dic`P0?1Tic100?0`000goo000;Ool01000Oomoogoo0`001Goo00<007ooOol09goo1dic:Woo
00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007oo
Ool00Goo000<Ool01000Oomoo`001goo00<007ooOol09goo1dic:Woo00<03gooOol0:goo00<03goo
Ool0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0009Ool40002Ool4
0004Ool00`00Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool0
0`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02Moo`M>LbYoo`0300moogoo
02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`00
5goo0P00:7oo1dic:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0
37oo1Tic1Goo0P000goo000GOol00`00Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0Z
Ool00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02Mo
o`M>LbYoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Io
o`03001oogoo005oo`005goo00<007ooOol09goo1dic:Woo00<03gooOol0:goo00<03gooOol0:Woo
00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2000XOol7CW<ZOol0
0`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<5Ool20003Ool0
01Moo`03001oogoo02Moo`M>LbYoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`03
00moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol09goo1dic:Woo00<03gooOol0
:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000G
Ool00`00Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?
Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02Moo`M>LbYoo`0300moogoo02]o
o`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo
0P00:7oo1dic:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo
1Tic1Goo0P000goo000GOol00`00Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol0
0`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02Moo`M>
LbYoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03
001oogoo005oo`005goo00<007ooOol09goo1dic:Woo00<03gooOol0:goo00<03gooOol0:Woo00<0
3gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2000XOol7CW<ZOol00`0?
Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<5Ool20003Ool001Mo
o`03001oogoo02Moo`M>LbYoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300mo
ogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol09goo1dic:Woo00<03gooOol0:goo
00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0003Ool3
0004Ool20004Ool20005Ool00`00Oomoo`0WOol7CW<ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol0
0`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000Aoo`03001oogoo009oo`04
001oogoo0002Ool01000Oomoo`0017oo00<007ooOol09goo1dic:Woo00<03gooOol0:goo00<03goo
Ool0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0004Ool00`00Oomo
o`02Ool01000Oomoo`000Woo00@007ooOol000Aoo`8002P03`M>Ll803`I>L`@03`<000=oo`0017oo
00<007ooOol00Woo00@007ooOol0009oo`04001oogoo0004Ool00`00Oomoo`0[Ool00`0?Oomoo`0Z
Ool00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00
Oomoo`01Ool000Aoo`03001oogoo009oo`04001oogoo0002Ool01000Oomoo`0017oo00<007ooOol0
:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0
37oo1Tic1Woo00<007ooOol00Goo0003Ool20005Ool20004Ool20005Ool00`00Oomoo`0[Ool00`0?
Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6
Ool00`00Oomoo`01Ool001Moo`8002aoo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yo
o`0300moogoo02]oo`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<007ooOol0:goo00<03goo
Ool0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo
00<007ooOol00Goo000GOol00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomo
o`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo
02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo
00aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0
:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000G
Ool2000/Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?
Oomoo`0<Ool6CW<5Ool20003Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]o
o`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo
00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo
00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol00`00Oomoo`0[Ool00`0?Oomoo`0ZOol0
0`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomo
o`01Ool001Moo`8002aoo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo
02]oo`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<0
3gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol0
0Goo000GOol00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?
Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02]oo`0300mo
ogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Io
o`03001oogoo005oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03goo
Ool0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2000/Ool0
0`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6
CW<5Ool20003Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo
02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`000goo0`000goo1000
0Woo0`001Goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<0
3gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0004Ool00`00Oomoo`03Ool00`00
Oomoo`05Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?
Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000Aoo`03001o
ogoo00Aoo`03001oogoo00Aoo`03001oogoo009oo`800?403`I>L`@03`<000=oo`0017oo00<007oo
Ool01Goo00<007ooOol00`001Goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<0
3gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo0004Ool00`00
Oomoo`02Ool01000Oomoo`000Woo00<007ooOol01Goo00<007ooOol0:goo00<03gooOol0:Woo00<0
3gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol0
0Goo0003Ool20005Ool20003Ool40004Ool00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[
Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Mo
o`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]o
o`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo0P00;7oo00<03gooOol0:Woo00<03goo
Ool0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Goo0P000goo000GOol0
0`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool0
0`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`03
00moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo
005oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<0
3gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2000/Ool00`0?Oomoo`0Z
Ool00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<5Ool20003
Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300mo
ogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol0:goo00<03goo
Ool0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo
00<007ooOol00Goo000GOol00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomo
o`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo
02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo
00aoo`I>L`Ioo`03001oogoo005oo`005goo0P00;7oo00<03gooOol0:Woo00<03gooOol0:goo00<0
3gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Goo0P000goo000GOol00`00Oomoo`0[
Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<
Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]o
o`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo
00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo
00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2000/Ool00`0?Oomoo`0ZOol00`0?Oomo
o`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<5Ool20003Ool001Moo`03
001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`03
00moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<0
3gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol0
0Goo0003Ool30003Ool30004Ool20005Ool00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[
Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000Ao
o`03001oogoo00Eoo`04001oogoo0002Ool00`00Oomoo`02Ool00`00Oomoo`0[Ool00`0?Oomoo`0Z
Ool00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00
Oomoo`01Ool000Aoo`03001oogoo00Eoo`04001oogoo0002Ool00`00Oomoo`02Ool2003a00l6CW<4
00l30003Ool000Aoo`03001oogoo009oo`<000=oo`04001oogoo0004Ool00`00Oomoo`0[Ool00`0?
Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6
Ool00`00Oomoo`01Ool000Aoo`03001oogoo009oo`03001oogoo00=oo`04001oogoo0004Ool00`00
Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?
Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool000=oo`8000Aoo`@000=oo`8000Eoo`03001oogoo02]o
o`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00ao
o`I>L`Ioo`03001oogoo005oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo
00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2
000/Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomo
o`0<Ool6CW<5Ool20003Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`03
00moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03001oogoo005oo`005goo00<0
07ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<0
3gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?
Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01
Ool001Moo`8002aoo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]o
o`0300moogoo00aoo`I>L`Eoo`8000=oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<03goo
Ool0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo
000GOol00`00Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomo
o`0[Ool00`0?Oomoo`0<Ool6CW<6Ool00`00Oomoo`01Ool001Moo`03001oogoo02]oo`0300moogoo
02Yoo`0300moogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo00aoo`I>L`Ioo`03
001oogoo005oo`005goo00<007ooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol0
:Woo00<03gooOol0:goo00<03gooOol037oo1Tic1Woo00<007ooOol00Goo000GOol2000/Ool00`0?
Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0ZOol00`0?Oomoo`0[Ool00`0?Oomoo`0<Ool6CW<5
Ool20003Ool001Moo`03001oogoo02]oo`0300moogoo02Yoo`0300moogoo02]oo`0300moogoo02Yo
o`0300moogoo02]oo`0300moogoo01Qoo`03001oogoo005oo`005goo00<007ooOol0:goo00<03goo
Ool0:Woo00<03gooOol0:goo00<03gooOol0:Woo00<03gooOol0:goo00<03gooOol067oo00<007oo
Ool00Goo000GOol00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`07Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool0
0`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`07Ool0
0`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`06Ool00`00Oomoo`01Ool0
01Moool0004000=oo`00\
\>"],
  ImageRangeCache->{{{0, 281}, {173, 0}} -> {-2.58224, -20.7252, 0.10984, 
  1.10495}}],

Cell[OutputFormData["\<\
Graphics[\"<<>>\"]\
\>", 
"\<\
-Graphics-\
\>"], "Output",
  Editable->False,
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->Automatic,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{4, Automatic}, {Automatic, 31}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T000000@0000
00000000004000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 109, 3, 136, "Title",
  Evaluatable->False],
Cell[1843, 56, 107, 3, 53, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1975, 63, 102, 3, 50, "Section",
  Evaluatable->False],
Cell[2080, 68, 905, 19, 222, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3022, 92, 110, 3, 50, "Section",
  Evaluatable->False],
Cell[3135, 97, 1209, 23, 254, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[4381, 125, 131, 3, 50, "Section",
  Evaluatable->False],
Cell[4515, 130, 439, 9, 78, "Text",
  Evaluatable->False],
Cell[4957, 141, 464, 10, 78, "Text",
  Evaluatable->False],
Cell[5424, 153, 239, 7, 64, "Input"],
Cell[5666, 162, 110, 3, 30, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[5813, 170, 111, 3, 50, "Section",
  Evaluatable->False],
Cell[5927, 175, 393, 11, 110, "Text",
  Evaluatable->False],
Cell[6323, 188, 682, 19, 129, "Input",
  InitializationCell->True],
Cell[7008, 209, 442, 9, 78, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7475, 222, 111, 2, 25, "Input"],
Cell[7589, 226, 231, 9, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[7835, 238, 199, 6, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8059, 248, 115, 2, 25, "Input"],
Cell[8177, 252, 270, 10, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[8462, 265, 902, 15, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9389, 284, 73, 2, 25, "Input"],
Cell[9465, 288, 292, 9, 78, "Print",
  Evaluatable->False]
}, Open  ]],
Cell[9772, 300, 130, 3, 25, "Input",
  InitializationCell->True],
Cell[9905, 305, 237, 7, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10167, 316, 143, 5, 38, "Input"],
Cell[10313, 323, 9225, 137, 160, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[19553, 463, 234, 7, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19812, 474, 115, 2, 25, "Input"],
Cell[19930, 478, 270, 10, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[20215, 491, 289, 7, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20529, 502, 86, 2, 25, "Input"],
Cell[20618, 506, 270, 10, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[20903, 519, 171, 6, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21099, 529, 136, 5, 38, "Input"],
Cell[21238, 536, 270, 10, 24, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[21523, 549, 615, 12, 110, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22163, 565, 100, 2, 25, "Input"],
Cell[22266, 569, 164, 8, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22479, 583, 117, 3, 50, "Section",
  Evaluatable->False],
Cell[22599, 588, 238, 7, 46, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22862, 599, 971, 27, 415, "Input"],
Cell[23836, 628, 37037, 1610, 182, 10241, 1273, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False],
Cell[60876, 2240, 150, 8, 24, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

